// WinSockTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WinSockTest.h"
#include "WinSockTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinSockTestDlg dialog

CWinSockTestDlg::CWinSockTestDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CWinSockTestDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CWinSockTestDlg)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinSockTestDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CWinSockTestDlg)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinSockTestDlg, CDialog)
    //{{AFX_MSG_MAP(CWinSockTestDlg)
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_TEST, OnTest)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinSockTestDlg message handlers

BOOL CWinSockTestDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);         // Set big icon
    SetIcon(m_hIcon, FALSE);        // Set small icon
    
    // TODO: Add extra initialization here
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinSockTestDlg::OnPaint() 
{
    if (IsIconic())
    {
        CPaintDC dc(this); // device context for painting

        SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics(SM_CXICON);
        int cyIcon = GetSystemMetrics(SM_CYICON);
        CRect rect;
        GetClientRect(&rect);
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // Draw the icon
        dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
        CDialog::OnPaint();
    }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWinSockTestDlg::OnQueryDragIcon()
{
    return (HCURSOR) m_hIcon;
}

#define BUFF_LEN 255 ///QCI
void CWinSockTestDlg::OnTest() ///QCI
{
    // Open a TCP socket
    CAsyncSocket tcpSock;
    if(!tcpSock.Create()){
        AfxMessageBox(GetLastErrorMsg());
        return ;
    }
    // Wait for connect
    char * ipAdr = "10.10.13.160";  // IP Address of E-485 Bridge
    UINT netPortNum = 10001;
    theApp.BeginWaitCursor(); 
    int numWaits = 120; 
    BOOL bConnected = FALSE;
    do {
        if(!tcpSock.Connect(ipAdr,netPortNum)){
            int lastErr = tcpSock.GetLastError();
            if(lastErr == WSAEISCONN){
                bConnected = TRUE;
                break; 
            }else{
                Sleep(100);
            }
        }else{
            break; // Success
        }
    }while(numWaits-->0 && !bConnected); 
    theApp.EndWaitCursor();

    // Fault out if timeout
    if(!bConnected){
        AfxMessageBox("Connect Timeout");
        return ;
    }
    // Copy POL command into Transmit Buffer
    CString strCmd = "@16 0";
    char txBuff[BUFF_LEN];
    for(int x=0;x<strCmd.GetLength();x++)
        txBuff[x] = strCmd.GetAt(x);
    txBuff[x++] = 0x0D; // Add CR
    int buffLen = x;

    // Send Transmit Buffer 
    if(tcpSock.Send(txBuff,buffLen) == SOCKET_ERROR){
        AfxMessageBox(GetLastErrorMsg());
        return;
    }
    // Wait for response
    Sleep(200);

    // Receive Data
    char rxBuff[BUFF_LEN];
    int numBytesRx = tcpSock.Receive( rxBuff, BUFF_LEN);
    if(numBytesRx == SOCKET_ERROR){
        AfxMessageBox(GetLastErrorMsg());
        return;
    }
    // Copy To Rx String
    CString strRx = "<nothing>";
    if(numBytesRx > 0){
        strRx = "";
        for(int x=0;x<numBytesRx;x++){
            if(rxBuff[x] == 0x0D)
                break;
            strRx += rxBuff[x];
        }
    }
    // Display Rx 
    AfxMessageBox(strRx);
}
/////////////////////////////////////////////////////////////////////
char * CWinSockTestDlg::GetLastErrorMsg(int errNum) ///QCI
// A socket error has occurred.  Lookup error message and return.
/////////////////////////////////////////////////////////////////////
{   
    switch(errNum){
    case WSANOTINITIALISED:
        return "A successful AfxSocketInit must occur before using this API";
    case WSAENETDOWN:
        return "The Windows Sockets implementation detected that the network subsystem failed";
    case WSAEADDRINUSE:
        return "The specified address is already in use";
    case WSAEINPROGRESS:
        return "A blocking Windows Sockets call is in progress";
    case WSAEADDRNOTAVAIL:
        return "The specified address is not available from the local machine";
    case WSAEAFNOSUPPORT:
        return "Addresses in the specified family cannot be used with this socket";
    case WSAECONNREFUSED:
        return "The attempt to connect was rejected";
    case WSAEDESTADDRREQ:
        return "A destination address is required";
    case WSAEFAULT:
        return "Bad address.  The Sock Addr Len argument is incorrect";
    case WSAEINVAL:
        return "Invalid host address";
    case WSAEISCONN:
        return "The socket is already connected";
    case WSAEMFILE:
        return "No more file descriptors are available";
    case WSAENETUNREACH:
        return "The network cannot be reached from this host at this time";
    case WSAENOBUFS:
        return "No buffer space is available. The socket cannot be connected";
    case WSAENOTSOCK:
        return "The descriptor is not a socket";
    case WSAETIMEDOUT:
        return "Attempt to connect timed out without establishing a connection";
    case WSAEWOULDBLOCK:
        return "The socket is marked as nonblocking and the connection cannot be completed immediately.";
    case WSAEACCES:
        return "The requested address is a broadcast address, but the appropriate flag was not set.";
    case WSAENETRESET:
        return "The connection must be reset because the Windows Sockets implementation dropped it.";
    case WSAENOTCONN:
        return "The socket is not connected.";
    case WSAEOPNOTSUPP:
        return "MSG_OOB was specified, but the socket is not of type SOCK_STREAM.";
    case WSAESHUTDOWN:
        return "The socket has been shut down; it is not possible to call Send on a socket after ShutDown has been invoked with nHow set to 1 or 2.";
    case WSAEMSGSIZE:
        return "The socket is of type SOCK_DGRAM, and the datagram is larger than the maximum supported by the Windows Sockets implementation.";
    case WSAECONNABORTED:
        return "The virtual circuit was aborted due to timeout or other failure.";
    case WSAECONNRESET:
        return "The virtual circuit was reset by the remote side. "; 
    case WSAEPROTONOSUPPORT:
        return "The specified port is not supported.";
    case WSAEPROTOTYPE:
        return "The specified port is the wrong type for this socket.";
    case WSAESOCKTNOSUPPORT:
        return "The specified socket type is not supported in this address family. ";
    case WSAEINTR:
        return "Interrupted system call.";
    case WSAEBADF:
        return "Bad file number.";
    case WSAEALREADY:
        return "Operation already in progress.";
    case WSAENOPROTOOPT:
        return "Protocol not available.";
    case WSAEPFNOSUPPORT:
        return "Protocol family not supported.";
    case WSAETOOMANYREFS:
        return "Too many references: cannot splice.";
    case WSAELOOP:
        return "Too many levels of symbolic links.";
    case WSAENAMETOOLONG:
        return "File name too long.";
    case WSAEHOSTDOWN:
        return "Host is down.";
    case WSAEHOSTUNREACH:
        return "No route to host or no host/server found.  Make sure the PC has a valid IP address.";
    case WSASYSNOTREADY:
        return "The network subsystem is unusable.";
    case WSAVERNOTSUPPORTED:
        return "The Windows Sockets DLL cannot support this application.";
    case WSAEDISCON:
        return "Disconnect.";
    case WSAHOST_NOT_FOUND:
        return "Host not found. This message indicates that the key (name, address, and so on) was not found.";
    case WSATRY_AGAIN:
        return "Nonauthoritative host not found. This error may suggest that the name service itself is not functioning.";
    case WSANO_RECOVERY:
        return "Nonrecoverable error. This error may suggest that the name service itself is not functioning.";
    case WSANO_DATA:
        return "Valid name, no data record of requested type. This error indicates that the key (name, address, and so on) was not found";
    default:
        {
            static char buff[100];
            sprintf(buff,"Error Number = %d",errNum);
            return buff;
        }
    }
}
