// FileCommTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FileCommTest.h"
#include "FileCommTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileCommTestDlg dialog

CFileCommTestDlg::CFileCommTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFileCommTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileCommTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFileCommTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileCommTestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFileCommTestDlg, CDialog)
	//{{AFX_MSG_MAP(CFileCommTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_TEST, OnTest)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileCommTestDlg message handlers

BOOL CFileCommTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
    ConfigureCOM(); ///QCI
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFileCommTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFileCommTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFileCommTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
/////////////////////////////////////////////////////////////////////////////
void CFileCommTestDlg::ConfigureCOM() ///QCI
// Configure Comm Port
/////////////////////////////////////////////////////////////////////
{
    // OPEN FILE TO COM1
	m_hComm = CreateFile("COM1",
            GENERIC_READ | GENERIC_WRITE,
            0,              // comm devices must be opened w/exclusive-access
            NULL,           // no security attrs
            OPEN_EXISTING,  // comm devices must use OPEN_EXISTING
            0,              // not overlapped I/O
            NULL            // hTemplate must be NULL for comm devices
            );
   
    
    if (m_hComm == INVALID_HANDLE_VALUE) {
        CString strMsg;
        strMsg.Format("Could Not Open COM 1");
        AfxMessageBox(strMsg);
        m_bCommEnabled = FALSE;
        SetFocus( ); 
    }
    // GET THE CURRENT CONFIGURATION. 
    DCB dcb;
    BOOL bSuccess = GetCommState(m_hComm, &dcb);

    // Exit on error
    if (!bSuccess) {
        AfxMessageBox("Unable to get DCB");
        return;
    }

    // SET COMM PORT TIMEOUTS
    COMMTIMEOUTS commTimeouts;
    commTimeouts.ReadIntervalTimeout = 5;
    commTimeouts.ReadTotalTimeoutMultiplier = 5;
    commTimeouts.ReadTotalTimeoutConstant = 50;
    commTimeouts.WriteTotalTimeoutMultiplier = 5;
    commTimeouts.WriteTotalTimeoutConstant = 100;
    bSuccess = SetCommTimeouts( m_hComm, &commTimeouts);

    // Exit on error
    if (!bSuccess) {
        AfxMessageBox("Unable to setup Timeouts");
        return;
    }

    // SET COMM STATE
    // Fill in the DCB: baud=57600, 8 data bits, no parity, 2 stop bit
    dcb.BaudRate = 57600;
    dcb.ByteSize = 8;
    dcb.Parity = NOPARITY;
    dcb.StopBits = TWOSTOPBITS;
    dcb.fRtsControl = RTS_CONTROL_TOGGLE;
    bSuccess = SetCommState(m_hComm, &dcb);
    
    // Exit on error
    if (!bSuccess){ 
        AfxMessageBox("Unable to setup Comm States");
        return;
    }

    // SETUP COMM
    bSuccess = SetupComm( m_hComm, 1024 /* rx buff size*/, 64 /*tx buff size*/ );

    // Exit on error
    if (!bSuccess)  {
        AfxMessageBox("Unable to setup Comm Buffers");
        return;
    }

    // CONFIGURE COMM PORT TO GENERATE AN "EVENT" ON
    // TRANSMIT BUFFER EMPTY
    bSuccess = SetCommMask( m_hComm, EV_TXEMPTY); 
 
    // Exit on error
    if (!bSuccess)  {
        AfxMessageBox("Unable to setup Comm Event Mask");
        return;
    }

    // SET FLAG FOR COMM PORT ENABLED
    m_bCommEnabled = TRUE;
}
/////////////////////////////////////////////////////////////////////////////
void CFileCommTestDlg::OnTest() ///QCI 
/////////////////////////////////////////////////////////////////////////////
{
    // SEND MOVE RELATIVE, TIME BASED(MRT)
    //  MRT 40000 count, 100ms Ramp Time, 1000ms Total Time
    CString strCmd;
    strCmd.Format("@16 177 40000 833 8333 0 0 %c",13);
    SendCommand(strCmd);
}
/////////////////////////////////////////////////////////////////////////////
int CFileCommTestDlg::SendCommand(CString & strCmd)  ///QCI
// Send given command to given device
// Return 1 == Success
// Return 0 == Failure
// Return -1 == NAK received
/////////////////////////////////////////////////////////////////////
{
    // MAKE SURE WE HAVE A VALID WINDOW AND THE COMM PORT IS ENABLED
    if (m_hComm == INVALID_HANDLE_VALUE)
        return 0;

    if(!m_bCommEnabled)
        return 0;

    // CLEAR OUT THE RECEIVE BUFFER
    PurgeComm(m_hComm, PURGE_RXCLEAR);
    
    // WRITE COMMAND TO COMM PORT
    DWORD nBytesWritten;            // Number of bytes written to comm port
    CONST VOID* buffer = strCmd;
    int strLen = strCmd.GetLength();
    BOOL bResult = WriteFile(m_hComm, buffer, strLen, &nBytesWritten, NULL); 

    // EXIT IF NO BYTES WRITTEN
    if (nBytesWritten == 0 ){ 
        AfxMessageBox("No Data Sent");
        m_bCommEnabled = FALSE;
        return 0;
    }
    // WAIT FOR COMM PORT TO TRANSMIT THE COMMAND
    //  Exit if an error occurs
    DWORD lpEvtMask;
    bResult = WaitCommEvent( m_hComm, &lpEvtMask, NULL); 
    if(!bResult ){
        AfxMessageBox("Wait on Comm Tx Error");
        return(0);
    }

    // Exit if transmit buffer not empty
    if( lpEvtMask != EV_TXEMPTY){
        AfxMessageBox("Tx Error");
        return 0;
    }
    
    // READ ACK
    // An ACK could contain data (ie status)

    // Read one byte at a time until a Carriage Return is found.
    //  Carriage Return is the "End of Packet" character.
    m_rxBuffLen = 0;
    DWORD numBytesRead;                 // Number of bytes read
    char rxData[256];                   // Buffer to hold received data (1 comm port read only)
    rxData[0] = NULL; // Terminate string
    CString strMsg = "Response: \n\n";
    while (rxData[0] != 13 ) {
        bResult = ReadFile(
            m_hComm, 
            &rxData, 
            1               /* num bytes to read*/, 
            &numBytesRead, 
            NULL);
        
        // Exit if error
        if(!bResult){
            AfxMessageBox("Error reading ACK");
            return 0;
        }
        // Exit if nothing read (timeout)
        if(numBytesRead == 0) {
            AfxMessageBox("Receive Buffer Empty");
            return 0;
        }

        // Copy the received byte to the receive buffer
        m_rxBuff[m_rxBuffLen] = rxData[0];
        strMsg += m_rxBuff[m_rxBuffLen];        
        m_rxBuffLen++;
        
    }

    // DISPLAY RESPONSE
    //  Get rid of the Carriage Return
    strLen = strMsg.GetLength();
    strMsg.SetAt(strLen-1,'\0');
    AfxMessageBox(strMsg);

    // RETURN IF NAK RECEIVED
    if (m_rxBuffLen > 0){
        if(m_rxBuff[0] == '!'){
            return(-1);
        }
    }

    // RETURN SUCCESS
    return(1);
}


