/////////////////////////////////////////////////////////////////////
// QuickSilver Controls, Inc
// Application Example
//
// MakeCirclesDlg.cpp : implementation file
// See MakeCircles.doc for details.
//
// 09/03/00
/////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "MakeCircles.h"
#include "MakeCirclesDlg.h"
#include "CircleSetup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
    CAboutDlg();

// Dialog rxData
    //{{AFX_DATA(CAboutDlg)
    enum { IDD = IDD_ABOUTBOX };
    //}}AFX_DATA

    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CAboutDlg)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //}}AFX_VIRTUAL

// Implementation
protected:
    //{{AFX_MSG(CAboutDlg)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
        // No message handlers
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesDlg dialog

CMakeCirclesDlg::CMakeCirclesDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CMakeCirclesDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMakeCirclesDlg)
    m_XaxisID = 16;
    m_YaxisID = 15;
	//}}AFX_DATA_INIT
    // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMakeCirclesDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CMakeCirclesDlg)
    DDX_Control(pDX, IDC_SLIDER1, m_jogYaxis);
    DDX_Control(pDX, IDC_SLIDER2, m_jogXaxis);
    DDX_Control(pDX, IDC_COM2, m_COM2);
    DDX_Control(pDX, IDC_COM1, m_COM1);
    DDX_Text(pDX, IDC_XaxisID, m_XaxisID);
    DDV_MinMaxUInt(pDX, m_XaxisID, 1, 254);
    DDX_Text(pDX, IDC_YaxisID, m_YaxisID);
    DDV_MinMaxUInt(pDX, m_YaxisID, 1, 254);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMakeCirclesDlg, CDialog)
    //{{AFX_MSG_MAP(CMakeCirclesDlg)
    ON_WM_SYSCOMMAND()
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_COM1, OnCom1)
    ON_BN_CLICKED(IDC_COM2, OnCom2)
    ON_BN_CLICKED(IDC_SETUPCIRCLE, OnSetupcircle)
    ON_BN_CLICKED(IDC_DOMOVE, OnDomove)
    ON_BN_CLICKED(IDC_RESTART, OnRestart)
    ON_WM_HSCROLL()
    ON_BN_CLICKED(IDC_STOP, OnStop)
    ON_WM_VSCROLL()
    ON_BN_CLICKED(IDC_GOTOCENTER, OnGotocenter)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////
int CMakeCirclesDlg::SendCommand(char * strCmd, bool bACKRequired) ///QCI
// Send given command and wait for ACK if required.
// 
// Return 1 == Success
// Return 0 == Failure
// Return -1 == NAK received
/////////////////////////////////////////////////////////////////////
{
    // MAKE SURE WE HAVE A VALID WINDOW AND THE COMM PORT IS ENABLED
    if (m_hComm == INVALID_HANDLE_VALUE)
        return 0;

    if(!m_bCommEnabled)
        return 0;

    // CLEAR OUT THE RECEIVE BUFFER
    PurgeComm(m_hComm, PURGE_RXCLEAR);
    
    // WRITE COMMAND TO COMM PORT
    DWORD nBytesWritten;            // Number of bytes written to comm port
    CONST VOID* buffer = strCmd;
    BOOL bResult = WriteFile(m_hComm, buffer, strlen(strCmd), &nBytesWritten, NULL); 

    // EXIT IF NO BYTES WRITTEN
    if (nBytesWritten == 0 ){ 
        AfxMessageBox("No Data Sent");
        m_bCommEnabled = FALSE;
        return 0;
    }

    // WAIT FOR COMM PORT TO TRANSMIT THE COMMAND
    //  Exit if an error occurs
    DWORD lpEvtMask;
    bResult = WaitCommEvent( m_hComm, &lpEvtMask, NULL); 
    if(!bResult ){
        AfxMessageBox("Wait on Comm Tx Error");
        return(0);
    }

    // Exit if transmit buffer not empty
    if( lpEvtMask != EV_TXEMPTY){
        AfxMessageBox("Tx Error");
        return 0;
    }

    // RETURN SUCCESS IF ACK IS NOT REQUIRED
    if(!bACKRequired)
        return 1;

    // READ ACK
    // An ACK could contain data (ie status)

    // Read one byte at a time until a Carriage Return is found.
    //  Carriage Return is the "End of Packet" character.
    char rxBuff[256];                   // Receive Buffer for incoming data
    int numBytesInRxBuff = 0;           // Number of bytes in receive buffer
    DWORD numBytesRead;                 // Number of bytes read
    char rxData[256];                   // Buffer to hold received data (1 comm port read only)
    rxData[0] = NULL; // Terminate string
    while (rxData[0] != 13 ) {
        bResult = ReadFile(
            m_hComm, 
            &rxData, 
            1               /* num bytes to read*/, 
            &numBytesRead, 
            NULL);
        
        // Exit if error
        if(!bResult){
            AfxMessageBox("Error reading ACK");
            return 0;
        }
        // Exit if nothing read
        if(numBytesRead == 0){
            AfxMessageBox("Receive Timeout");
            return(0);
        }

        // Copy the received byte to the receive buffer
        rxBuff[numBytesInRxBuff] = rxData[0];
        numBytesInRxBuff++;
    }

    // RETURN IF NAK RECEIVED
    if (numBytesInRxBuff > 0){
        if(rxBuff[0] == '!'){
            return(-1);
        }
    }

    // RETURN SUCCESS
    return(1);
}
    
/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::ConfigureCOM(CString strCommPort)///QCI
// Configure Comm Ports
/////////////////////////////////////////////////////////////////////
{

    // OPEN FILE TO COM1
	m_hComm = CreateFile(strCommPort,
            GENERIC_READ | GENERIC_WRITE,
            0,              // comm devices must be opened w/exclusive-access
            NULL,           // no security attrs
            OPEN_EXISTING,  // comm devices must use OPEN_EXISTING
            0,              // not overlapped I/O
            NULL            // hTemplate must be NULL for comm devices
            );
   
    
    if (m_hComm == INVALID_HANDLE_VALUE) {
        CString strMsg;
        strMsg.Format("Could Not Open %s", strCommPort);
        AfxMessageBox(strMsg);
        m_bCommEnabled = FALSE;
        SetFocus( ); 
    }
    // GET THE CURRENT CONFIGURATION. 
    DCB dcb;
    BOOL bSuccess = GetCommState(m_hComm, &dcb);

    // Exit on error
    if (!bSuccess) {
        AfxMessageBox("Unable to get DCB");
        return;
    }

    // SET COMM PORT TIMEOUTS
    COMMTIMEOUTS commTimeouts;
    commTimeouts.ReadIntervalTimeout = 5;
    commTimeouts.ReadTotalTimeoutMultiplier = 5;
    commTimeouts.ReadTotalTimeoutConstant = 50;
    commTimeouts.WriteTotalTimeoutMultiplier = 5;
    commTimeouts.WriteTotalTimeoutConstant = 100;
    bSuccess = SetCommTimeouts( m_hComm, &commTimeouts);

    // Exit on error
    if (!bSuccess) {
        AfxMessageBox("Unable to setup Timeouts");
        return;
    }

    // SET COMM STATE
    // Fill in the DCB: baud=57600, 8 data bits, no parity, 2 stop bit
    dcb.BaudRate = 57600;
    dcb.ByteSize = 8;
    dcb.Parity = NOPARITY;
    dcb.StopBits = TWOSTOPBITS;
    dcb.fRtsControl = RTS_CONTROL_TOGGLE;
    bSuccess = SetCommState(m_hComm, &dcb);
    
    // Exit on error
    if (!bSuccess){ 
        AfxMessageBox("Unable to setup Comm States");
        return;
    }

    // SETUP COMM
    bSuccess = SetupComm( m_hComm, 1024 /* rx buff size*/, 64 /*tx buff size*/ );

    // Exit on error
    if (!bSuccess)  {
        AfxMessageBox("Unable to setup Comm Buffers");
        return;
    }

    // CONFIGURE COMM PORT TO GENERATE AN "EVENT" ON
    // TRANSMIT BUFFER EMPTY
    bSuccess = SetCommMask( m_hComm, EV_TXEMPTY); 
 
    // Exit on error
    if (!bSuccess)  {
        AfxMessageBox("Unable to setup Comm Event Mask");
        return;
    }

    // SET FLAG FOR COMM PORT ENABLED
    m_bCommEnabled = TRUE;

}
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesDlg message handlers
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
BOOL CMakeCirclesDlg::OnInitDialog()
/////////////////////////////////////////////////////////////////////
{
    CDialog::OnInitDialog();

    // Add "About..." menu item to system menu.

    // IDM_ABOUTBOX must be in the system command range.
    ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
    ASSERT(IDM_ABOUTBOX < 0xF000);

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        CString strAboutMenu;
        strAboutMenu.LoadString(IDS_ABOUTBOX);
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
    }

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);         // Set big icon
    SetIcon(m_hIcon, FALSE);        // Set small icon

    // INITIALIZE MEMBERS ///QCI
    m_hComm = NULL;
    m_bCommEnabled = FALSE;
    m_bCITCalculated = FALSE;
    m_jogXaxis.SetRange( -100, 100, TRUE );
    m_jogXaxis.SetPos(0);
    m_jogYaxis.SetRange( -100, 100, TRUE );
    m_jogYaxis.SetPos(0);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::PostNcDestroy() 
/////////////////////////////////////////////////////////////////////
{
    // Close the Comm Port File
    if (m_hComm != NULL && m_hComm != INVALID_HANDLE_VALUE){
        CloseHandle(m_hComm);
    }
    
    CDialog::PostNcDestroy();
}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnSysCommand(UINT nID, LPARAM lParam)
/////////////////////////////////////////////////////////////////////
{
    if ((nID & 0xFFF0) == IDM_ABOUTBOX)
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand(nID, lParam);
    }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnPaint() 
/////////////////////////////////////////////////////////////////////
{
    if (IsIconic())
    {
        CPaintDC dc(this); // device context for painting

        SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics(SM_CXICON);
        int cyIcon = GetSystemMetrics(SM_CYICON);
        CRect rect;
        GetClientRect(&rect);
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // Draw the icon
        dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
        CDialog::OnPaint();
    }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
/////////////////////////////////////////////////////////////////////
HCURSOR CMakeCirclesDlg::OnQueryDragIcon()
/////////////////////////////////////////////////////////////////////
{
    return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnComX(int commPortNum) ///QCI
// When the user selects a new Comm port, configure the selected port
// and disable the other ports.
// commPortNum 0 = COM1
// commPortNum 1 = COM2
//  .....
/////////////////////////////////////////////////////////////////////
{   
    // Close comm if already open
    if(m_hComm != NULL && m_hComm != INVALID_HANDLE_VALUE) 
        CloseHandle(m_hComm);

    // Clear all the check boxes
    m_COM1.SetCheck(0);
    m_COM2.SetCheck(0);

    // Set the correct check box and determine the 
    // comm port string.
    CString strCommPort;
    switch(commPortNum){
    case 0:
        strCommPort = "COM1";
        m_COM1.SetCheck(1);
        break;
    case 1:
        strCommPort = "COM2";
        m_COM2.SetCheck(1);
        break;
    default:
        ASSERT(0); //should never get here
    }

    // CONFIGURE COMM PORT 
    ConfigureCOM(strCommPort);
}
/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnCom1()
/////////////////////////////////////////////////////////////////////
{
    OnComX(0);
}
void CMakeCirclesDlg::OnCom2()
{
    OnComX(1);
}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnSetupcircle()
/////////////////////////////////////////////////////////////////////
{

    // Initialize the "Circle Setup" dialog box and launch it.
    CCircleSetup dlg;
    dlg.m_maxVel = m_maxVel;
    dlg.m_radius = m_radius;
    dlg.m_startAngle = m_startAngle;
    dlg.m_XOffset = m_XOffset;
    dlg.m_XScaleFactor = m_XScaleFactor;
    dlg.m_YScaleFactor = m_YScaleFactor;
    dlg.m_YMaxAcc = m_YMaxAcc;
    dlg.m_YMaxVel = m_YMaxVel;
    dlg.m_YOffset = m_YOffset;
    dlg.m_distanceAngle = m_distanceAngle;
    dlg.m_XMaxVel = m_XMaxVel;
    dlg.m_XMaxAcc = m_XMaxAcc;
    dlg.m_numCITSegments = m_numCITSegments;

    if (dlg.DoModal() == IDOK)   {
        for (long i = 1; i < dlg.m_numCITSegments + 3 ; i++)
        {
            m_motorTime[i] = dlg.m_motorTime[i];
            m_motorVelX[i] = dlg.m_motorVelX[i];
            m_motorVelY[i] = dlg.m_motorVelY[i];
            m_motorAccX[i] = dlg.m_motorAccX[i];
            m_motorAccY[i] = dlg.m_motorAccY[i];
            m_motorPosX[i] = dlg.m_motorPosX[i];
            m_motorPosY[i] = dlg.m_motorPosY[i];
        }
        m_motorTime[i] = 0;
        m_motorVelX[i] = 0;
        m_motorVelY[i] = 0;
        m_motorAccX[i] = 0;
        m_motorAccY[i] = 0;
        m_motorPosX[i] = 0;
        m_motorPosY[i] = 0;

        m_maxVel = dlg.m_maxVel;
        m_radius = dlg.m_radius;
        m_startAngle = dlg.m_startAngle;
        m_XOffset = dlg.m_XOffset;
        m_XScaleFactor = dlg.m_XScaleFactor;
        m_YScaleFactor = dlg.m_YScaleFactor;
        m_YMaxAcc = dlg.m_YMaxAcc;
        m_YMaxVel = dlg.m_YMaxVel;
        m_YOffset = dlg.m_YOffset;
        m_distanceAngle = dlg.m_distanceAngle;
        m_XMaxVel = dlg.m_XMaxVel;
        m_XMaxAcc = dlg.m_XMaxAcc;
        m_numCITSegments = dlg.m_numCITSegments;

        m_bCITCalculated = TRUE;
    }

}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnDomove() ///QCI
// Do the already calculated move.
/////////////////////////////////////////////////////////////////////
{
    // EXIT COMM NOT ENABLE
    if(!m_bCommEnabled){
        AfxMessageBox("Enable A Comm Port first");
        return;
    }

    // EXIT IF CIT NOT CALCULATED
    if(!m_bCITCalculated){
        AfxMessageBox("Calculate Circle First");
        return;
    }

    // START PROGRAMS
    //  Send a LRP:Load and Run Prgram to both axis
    UpdateData(RETRIEVE_DATA);
    int status;
    char strCmd[100];
    sprintf(strCmd,"@%d 156 512%c", m_XaxisID, 13);
    status = SendCommand(strCmd, TRUE);
    if(status == 0) {
        AfxMessageBox("Move Could not start due to X axis Comm failure");
        return;
    }
    sprintf(strCmd,"@%d 156 512%c", m_YaxisID, 13);
    status = SendCommand(strCmd, TRUE);
    if(status == 0){
        AfxMessageBox("Move Could not start due to Y axis Comm failure");
        return;
    }

    // FOR EACH SEGMENT
    for(long i = 2; i < m_numCITSegments + 4 ; i++){

        // SEND CIT POINT
        //  Send X Axis Circular Interpolation Table Value.
        //  Send the command until a NAK is not received.  
        //  A NAK indicates the servo queue is full.
        do {
            // This command has all the values in it
            sprintf(strCmd,"@%d 25 %d %d %d %d %c", 
                m_XaxisID, 
                m_motorTime[i], 
                m_motorPosX[i], 
                m_motorAccX[i], 
                m_motorVelX[i], 
                13);
            status = SendCommand(strCmd, TRUE);
        }
        while(status == -1);

        // Send Y Axis CIT
        do {
            sprintf(strCmd,"@%d 25 %d %d %d %d %c", 
                m_YaxisID, 
                m_motorTime[i], 
                m_motorPosY[i], 
                m_motorAccY[i], 
                m_motorVelY[i], 
                13);
            status = SendCommand(strCmd, TRUE);
        }
        while(status == -1);

        // START MOVE AFTER TWO CIT POINTS 
        // Writing a 1 to reg 11 notifies X axis (leader)
        // to start the move.  The Leader will then set an
        // output to signal the Y Axis (Follower) to start.
        if( i == 4) {

            // WRI: Reg 11 = 1
            sprintf(strCmd,"@%d 11 11 1 %c", m_XaxisID,13);
            status = SendCommand(strCmd, TRUE);
            if(status == 0) {
                AfxMessageBox("Move Could not start due to Y axis Comm failure");
                return;
            }
        }
    // END FOR EACH SEGMENT
    }

    // END MOVE
    // This signals the end of the move
    // WRI:  Reg 11 = 0
    sprintf(strCmd,"@%d 11 11 0 %c", m_XaxisID,13);
    SendCommand(strCmd, TRUE);

}


/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnRestart() 
/////////////////////////////////////////////////////////////////////
{
    char strCmd[100];

    // Send "Restart" command
    sprintf(strCmd,"@%d 4 %c",m_XaxisID,13);
    SendCommand(strCmd, FALSE);

    sprintf(strCmd,"@%d 4 %c",m_YaxisID,13);
    SendCommand(strCmd, FALSE);
    
}
/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnStop() 
/////////////////////////////////////////////////////////////////////
{
    char strCmd[100];

    // Send "Stop" command
    sprintf(strCmd,"@255 3 0%c", 13);
    SendCommand(strCmd, FALSE);

}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) ///QCI
/////////////////////////////////////////////////////////////////////
{
    // Send VMI:Velocity Mode, Immediate Mode commands with the velocity
    // proportional to the slider position.
    // NOTE:  The constants in the Acc and Vel parameters are scaling factors.
    char strCmd[100];
    if( nSBCode == TB_THUMBTRACK){
        sprintf(strCmd,"@%d 15 %d %d 0 0%c",m_XaxisID, (nPos * -5368), (nPos * -536781), 13);
        SendCommand(strCmd, FALSE);
    }

    if( nSBCode == TB_ENDTRACK){
        sprintf(strCmd,"@%d 3 0%c",m_XaxisID,13);
        SendCommand(strCmd, FALSE);
        m_jogXaxis.SetPos(0);
    }
    
    CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) ///QCI
/////////////////////////////////////////////////////////////////////
{
    // See OnHScroll()
    char strCmd[100];
    if( nSBCode == TB_THUMBTRACK){
        sprintf(strCmd,"@%d 15 %d %d 0 0%c",m_YaxisID, (nPos * 5368), (nPos * 536781), 13);
        SendCommand(strCmd, FALSE);
    }

    if( nSBCode == TB_ENDTRACK){
        sprintf(strCmd,"@%d 3 0%c",m_YaxisID,13);
        SendCommand(strCmd, FALSE);
        m_jogYaxis.SetPos(0);
    }
    
    CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

/////////////////////////////////////////////////////////////////////
void CMakeCirclesDlg::OnGotocenter() 
/////////////////////////////////////////////////////////////////////
{
    // Command the motor the coordinate 0,0
    char strCmd[100];
    sprintf(strCmd,"@%d 134 %d %d %d 0 0%c",m_XaxisID, 0, 5368, 5367810, 13);
    SendCommand(strCmd, FALSE);

    sprintf(strCmd,"@%d 134 %d %d %d 0 0%c",m_YaxisID, 0, 5368, 5367810, 13);
    SendCommand(strCmd, FALSE);
    
}

