/////////////////////////////////////////////////////////////////////
// QuickSilver Controls, Inc
// Application Example
//
// MakeCircles.cpp : Defines the class behaviors for the application.
// See MakeCircles.doc for details.
//
// PROGRAM NOTES:
//
//  ///QCI
//      This tag denotes import QCI Specific code.  Since Microsoft
//      writes a lot of code for you, this tag is placed next
//      code created by QCI so the reader can quickly search
//      through the software for the "important" stuff.
//
// 09/03/00
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MakeCircles.h"
#include "MakeCirclesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesApp

BEGIN_MESSAGE_MAP(CMakeCirclesApp, CWinApp)
    //{{AFX_MSG_MAP(CMakeCirclesApp)
        // NOTE - the ClassWizard will add and remove mapping macros here.
        //    DO NOT EDIT what you see in these blocks of generated code!
    //}}AFX_MSG
    ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesApp construction

CMakeCirclesApp::CMakeCirclesApp()
{
    // TODO: add construction code here,
    // Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMakeCirclesApp object

CMakeCirclesApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesApp initialization
BOOL CMakeCirclesApp::InitInstance()
/////////////////////////////////////////////////////////////////////////////
{
    AfxEnableControlContainer();

    // Standard initialization
    // If you are not using these features and wish to reduce the size
    //  of your final executable, you should remove from the following
    //  the specific initialization routines you do not need.

#ifdef _AFXDLL
    Enable3dControls();         // Call this when using MFC in a shared DLL
#else
    Enable3dControlsStatic();   // Call this when linking to MFC statically
#endif


    CMakeCirclesDlg dlg;
    m_pMainWnd = &dlg;

    // Get the last used parameters from MakeCircles.ini (in windows directory) ///QCI
    dlg.m_maxVel = (float)GetProfileInt( "Circle", "Max Velocity", 2 );
    dlg.m_radius = (float)GetProfileInt( "Circle", "Radius", 2 );
    dlg.m_startAngle = (float)GetProfileInt( "Circle", "Start Angle", 0 );
    dlg.m_XOffset = (float)GetProfileInt( "Circle", "X Offset", 0 );
    dlg.m_YOffset = (float)GetProfileInt( "Circle", "Y Offset", 0 );
    dlg.m_XScaleFactor = (int)GetProfileInt( "Circle", "X Scale Factor", 4000 );
    dlg.m_YScaleFactor = (int)GetProfileInt( "Circle", "Y Scale Factor", 4000 );
    dlg.m_YMaxAcc = (int)GetProfileInt( "Circle", "Y Max Accel", 15000 );
    dlg.m_YMaxVel = (int)GetProfileInt( "Circle", "Y Max Velocity", 2500 );
    dlg.m_distanceAngle = (float)GetProfileInt( "Circle", "Distance Angle", 180 );
    dlg.m_XMaxVel = (int)GetProfileInt( "Circle", "X Max Velocity", 2500 );
    dlg.m_XMaxAcc = (int)GetProfileInt( "Circle", "X Max Accel", 15000 );
    dlg.m_numCITSegments = (int)GetProfileInt( "Circle", "Number of Segments", 20 );

    dlg.m_XaxisID = (int)GetProfileInt( "Device", "X ID", 16 );
    dlg.m_YaxisID = (int)GetProfileInt( "Device", "Y ID", 15 );

    int nResponse = dlg.DoModal();
    if (nResponse == IDOK)
    {
        WriteProfileInt("Circle", "Max Velocity", (int)dlg.m_maxVel );
        WriteProfileInt("Circle", "Radius", (int)dlg.m_radius );
        WriteProfileInt("Circle", "Start Angle", (int)dlg.m_startAngle );
        WriteProfileInt("Circle", "X Offset", (int)dlg.m_XOffset );
        WriteProfileInt("Circle", "Y Offset", (int)dlg.m_YOffset );
        WriteProfileInt("Circle", "X Scale Factor", (int)dlg.m_XScaleFactor );
        WriteProfileInt("Circle", "Y Scale Factor", (int)dlg.m_YScaleFactor );
        WriteProfileInt("Circle", "Y Max Accel", (int)dlg.m_YMaxAcc );
        WriteProfileInt("Circle", "Y Max Velocity", (int)dlg.m_YMaxVel );
        WriteProfileInt("Circle", "Distance Angle", (int)dlg.m_distanceAngle );
        WriteProfileInt("Circle", "X Max Velocity", (int)dlg.m_XMaxVel );
        WriteProfileInt("Circle", "X Max Accel", (int)dlg.m_XMaxAcc );
        WriteProfileInt("Circle", "Number of Segments", (int)dlg.m_numCITSegments );

        WriteProfileInt("Device", "X ID", dlg.m_XaxisID );
        WriteProfileInt("Device", "Y ID", dlg.m_YaxisID );
        //  dismissed with OK
    }
    else if (nResponse == IDCANCEL)
    {
        // TODO: Place code here to handle when the dialog is
        //  dismissed with Cancel
    }

    // Since the dialog has been closed, return FALSE so that we exit the
    //  application, rather than start the application's message pump.
    return FALSE;
}
