/////////////////////////////////////////////////////////////////////
// QuickSilver Controls, Inc
// Application Example
//
// CircleSetup.cpp : implementation file
// See MakeCircles.doc for details.
//
// 09/03/00
/////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MakeCircles.h"
#include "CircleSetup.h"
#include <math.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const double PI = 3.141592654;

// disable the warning about "Possible loss of data when converting a long to double
#pragma warning( disable :  4244)

/////////////////////////////////////////////////////////////////////////////
// CCircleSetup dialog


CCircleSetup::CCircleSetup(CWnd* pParent /*=NULL*/)
    : CDialog(CCircleSetup::IDD, pParent)
{
    //{{AFX_DATA_INIT(CCircleSetup)
    m_maxVel= 2.0f;
    m_radius = 2.0f;
    m_startAngle = 0.0f;
    m_XOffset = 0.0f;
    m_XScaleFactor = 4000;
    m_YMaxAcc = 15000;
    m_YMaxVel = 2500;
    m_YOffset = 0.0f;
    m_distanceAngle = 180.0f;
    m_XMaxVel = 2500;
    m_XMaxAcc = 15000;
    m_YScaleFactor = 4000;
	m_numCITSegments = 0;
	//}}AFX_DATA_INIT

}


void CCircleSetup::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCircleSetup)
    DDX_Control(pDX, IDC_XYTABLE, m_XYTable);
    DDX_Text(pDX, IDC_MAXVELOCITY, m_maxVel);
    DDV_MinMaxFloat(pDX, m_maxVel, 0.f, 100.f);
    DDX_Text(pDX, IDC_RADIUS, m_radius);
    DDV_MinMaxFloat(pDX, m_radius, 0.f, 1000.f);
    DDX_Text(pDX, IDC_STARTANGLE, m_startAngle);
    DDV_MinMaxFloat(pDX, m_startAngle, -360.f, 360.f);
    DDX_Text(pDX, IDC_XOFFSET, m_XOffset);
    DDV_MinMaxFloat(pDX, m_XOffset, -100.f, 100.f);
    DDX_Text(pDX, IDC_XSCALEFACTOR, m_XScaleFactor);
    DDV_MinMaxLong(pDX, m_XScaleFactor, -100000, 100000);
    DDX_Text(pDX, IDC_YMAXACCEL, m_YMaxAcc);
    DDV_MinMaxLong(pDX, m_YMaxAcc, 0, 300000);
    DDX_Text(pDX, IDC_YMAXVELO, m_YMaxVel);
    DDV_MinMaxLong(pDX, m_YMaxVel, 0, 4000);
    DDX_Text(pDX, IDC_YOFFSET, m_YOffset);
    DDV_MinMaxFloat(pDX, m_YOffset, -100.f, 100.f);
    DDX_Text(pDX, IDC_DISTANGLE, m_distanceAngle);
    DDV_MinMaxFloat(pDX, m_distanceAngle, -360.f, 360.f);
    DDX_Text(pDX, IDC_XMAXVELO, m_XMaxVel);
    DDV_MinMaxLong(pDX, m_XMaxVel, 0, 4000);
    DDX_Text(pDX, IDC_XMAXACCEL, m_XMaxAcc);
    DDV_MinMaxLong(pDX, m_XMaxAcc, 0, 15000);
    DDX_Text(pDX, IDC_YSCALEFACTOR, m_YScaleFactor);
    DDV_MinMaxLong(pDX, m_YScaleFactor, -100000, 100000);
	DDX_Text(pDX, IDC_NUMSEGMENTS, m_numCITSegments);
	DDV_MinMaxLong(pDX, m_numCITSegments, 1, 200);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCircleSetup, CDialog)
    //{{AFX_MSG_MAP(CCircleSetup)
    ON_EN_KILLFOCUS(IDC_RADIUS, OnKillfocusRadius)
    ON_EN_KILLFOCUS(IDC_DISTANGLE, OnKillfocusDistangle)
    ON_EN_KILLFOCUS(IDC_MAXVELOCITY, OnKillfocusMaxvelocity)
    ON_EN_KILLFOCUS(IDC_STARTANGLE, OnKillfocusStartangle)
    ON_EN_KILLFOCUS(IDC_XMAXACCEL, OnKillfocusXmaxaccel)
    ON_EN_KILLFOCUS(IDC_XMAXVELO, OnKillfocusXmaxvelo)
    ON_EN_KILLFOCUS(IDC_XOFFSET, OnKillfocusXoffset)
    ON_EN_KILLFOCUS(IDC_XSCALEFACTOR, OnKillfocusXscalefactor)
    ON_EN_KILLFOCUS(IDC_YMAXACCEL, OnKillfocusYmaxaccel)
    ON_EN_KILLFOCUS(IDC_YMAXVELO, OnKillfocusYmaxvelo)
    ON_EN_KILLFOCUS(IDC_YOFFSET, OnKillfocusYoffset)
    ON_BN_CLICKED(IDC_CALCULATE, OnCalculate)
    ON_EN_KILLFOCUS(IDC_NUMSEGMENTS, OnKillfocusNumsegments)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CCircleSetup message handlers
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
BOOL CCircleSetup::OnInitDialog() 
/////////////////////////////////////////////////////////////////////
{
    CDialog::OnInitDialog();

    m_XYTable.SetHorizontalExtent(4000 /* pixcels */ );

    
    return TRUE;  // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnOK() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);

    // Build Circular Interpolation Table (CIT)
    BuildTable();
    
    CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnCalculate() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);

    // Build Circular Interpolation Table (CIT)
    BuildTable();
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusRadius() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}
/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusDistangle() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusMaxvelocity() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusStartangle() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusXmaxaccel() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusXmaxvelo() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusXoffset() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusXscalefactor() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusYmaxaccel() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusYmaxvelo() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusYoffset() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::OnKillfocusNumsegments() 
/////////////////////////////////////////////////////////////////////
{
    UpdateData(RETRIEVE_DATA);

    // Calculate Time Slice (see MakeCircles.doc for details) ///QCI
    double TimeSlice = 
        fabs((2 * m_radius * PI) * fabs(m_distanceAngle / 360) / m_maxVel / m_numCITSegments);

    // Adjust the number of CIT segments if time slice is too small
    if(TimeSlice < 0.05){
        CString strMsg;
        strMsg = "Time Slice is to small. The number of segments will be adjusted";
        AfxMessageBox(strMsg);

        m_numCITSegments = (unsigned long)fabs((2 * m_radius * PI) * fabs(m_distanceAngle / 360) / m_maxVel)/0.1;
        UpdateData(SAVE_DATA);
    }
}

/////////////////////////////////////////////////////////////////////
void CCircleSetup::BuildTable() ///QCI
// Build Circular Interpolation Table(CIT)
// See MakeCircles.doc for details.
/////////////////////////////////////////////////////////////////////
{
    
    m_XYTable.ResetContent( );

    CString Display;

    // Distances
    double X[MAXSEGMENTS];
    double Y[MAXSEGMENTS];

    double cosa[MAXSEGMENTS];
    double sina[MAXSEGMENTS];
    
    double dx[MAXSEGMENTS];             // Delta position.
    double dy[MAXSEGMENTS];
    double XTotalDistance;
    double YTotalDistance;

    double Tam[MAXSEGMENTS];            // Time Acc Max - Max Time Slice due to Acc limits
    double Tvm[MAXSEGMENTS];            // Time Vel Max - Max Time Slice due to velocity limits

    double Vvx[MAXSEGMENTS];            // Max velocity due to Time Vel Max (Tvm)
    double Vvy[MAXSEGMENTS];


    // Copy member functions variables matching spreadsheet
    double X1 = m_XOffset;  // First data point of arc
    double Y1 = m_YOffset;
    double r = m_radius;
    double ao = m_startAngle;
    double Vmx = m_XMaxVel;
    double Vmy = m_YMaxVel;

    XTotalDistance = 0;
    YTotalDistance = 0;

    double TimeSlice = fabs((2 * m_radius * PI) * fabs(m_distanceAngle / 360) / m_maxVel / m_numCITSegments);
    long TimeTrunc = TimeSlice * 8333;
    double Ts = TimeTrunc * 0.00012;

    // Center of Arc (origin of arc)
    double Xo = X1 - r * cos(2 * PI * ao / 360);
    double Yo = Y1 - r * sin(2 * PI * ao / 360);

    // Angle Increment
    double ai = m_distanceAngle / m_numCITSegments;

    // Angle
    double a = ao;
    long i = 0;
    X[i] = 0;
    Y[i] = 0;
    for(i = 1; i < m_numCITSegments + 3; i++)
    {
        // Scale the Angle for the sin table
        if (a > 360)
            a = a - 360;
        if (a < 0)
            a = a + 360;
        
        // cos(a) and sin(a)
        cosa[i] = cos(2 * PI * a/ 360);
        sina[i] = sin(2 * PI * a/ 360);
        X[i] = (cosa[i] * r + Xo) * m_XScaleFactor;
        Y[i] = (sina[i] * r + Yo) * m_YScaleFactor;
        
        dx[i] = X[i] - X[i-1];
        dy[i] = Y[i] - Y[i-1];

        if(i == m_numCITSegments + 2){
            dx[i] = 0;
            dy[i] = 0;
        }

        XTotalDistance += dx[i];
        YTotalDistance += dy[i];
        
      
        // TimeX (Tx) and TimeY (Ty)
        double Tvx = fabs(dx[i] / (Vmx/60*4000));
        double Tvy = fabs(dy[i] / (Vmy/60*4000));
        
        // Time Max (Tm)
        if( Ts > Tvx)
            Tvm[i] = Ts;
        else if (Tvx> Tvy)
            Tvm[i] = Tvx;
        else
            Tvm[i] = Tvy;
    
        // Velocity X and Y due to Max Vel Times (Vvx and Vvy)
        Vvx[i] = dx[i] / Tvm[i];
        Vvy[i] = dy[i] / Tvm[i];
       
        // Acc Times (Tax and Tay)
        double xMaxAcc = m_XMaxAcc; // copy to double 
        double yMaxAcc = m_YMaxAcc; // copy to double 
            // (this done first to avoid truncation during floating point operation)

        double Tax = fabs((Vvx[i]-Vvx[i-1]) / (xMaxAcc/60.0 * 4000.0)); 
        double Tay = fabs((Vvy[i]-Vvy[i-1]) / (yMaxAcc/60.0 * 4000.0));
        
        // Time Acc Max (Tam)
        if ( Tax > Tay)
            Tam[i] = Tax;
        else
            Tam[i] = Tay;

        // Increment angle
        a = a + ai;
    }
    
    for ( i = 1; i < m_numCITSegments + 3; i++) {
    
        // Time Min (Tmin)
        double Tmin;
        if (Tam[i] > Tvm[i])
            Tmin = Tam[i];
        else if (Tvm[i] > (Tam[i + 1] / 2 + Tam[i] / 2))
            Tmin = Tvm[i];
        else
            Tmin = Tam[i + 1] / 2 + Tam[i] / 2;

        // Runtime
        double RunTime = Tmin - Tam[i + 1] / 2 + Tam[i] / 2;

        // Velocity and Acceleration (Vx, Vy, Ax, Ay)
        double Vx = dx[i] / Tmin;
        double Vy = dy[i] / Tmin;
        double Ax = (Vvx[i] - Vvx[i-1]) / Tam[i];
        double Ay = (Vvy[i] - Vvy[i-1]) / Tam[i];

        // Build CIT
        // Vel and Acc entries are forced positive as required by the servo.
        //  Note:  Direction is determined by Motor Position.
        m_motorTime[i] = RunTime / 0.00012;
        m_motorVelX[i] = fabs(Vx * (0.00012 * pow(2,26)));
        m_motorVelY[i] = fabs(Vy * (0.00012 * pow(2,26)));
        m_motorAccX[i] = fabs(Ax * pow(0.00012,2) * pow(2,26));
        m_motorAccY[i] = fabs(Ay * pow(0.00012,2) * pow(2,26));

        // Set motor position to some large number so we never get there.
        // This puts the servo into a velocity mode.
        if (Vx < 0 )
            m_motorPosX[i] = -2000000;
        else
            m_motorPosX[i] = 2000000;

        // If vel == 0, set position to current position
        if (Vx == 0 ){
            m_motorPosX[i] = XTotalDistance;
            m_motorVelX[i] = m_motorVelX[i - 1];
        }
       
        if (Vy < 0)
            m_motorPosY[i] = -2000000;
        else
            m_motorPosY[i] = 2000000;

        if (Vy == 0 ) {
            m_motorPosY[i] = YTotalDistance;
            m_motorVelY[i] = m_motorVelY[i - 1];
        }

        Display.Format("%ld %ld CIT:VelX= %ld AccX= %ld PosX= %ld PosY= %ld",
            i,
            m_motorTime[i],
            m_motorVelX[i],
            m_motorAccX[i], 
            m_motorPosX[i],
            m_motorPosY[i]
            );

        /*
        Display.Format("cosa= %.3f, X= %.3f, dx= %.3f, Tvm = %.5f, Vvx= %.3f, Tam= %.6f",
            cosa[i],
            X[i],
            dx[i],
            Tvm[i],
            Vvx[i],
            Tam[i]
            );
            */

        m_XYTable.InsertString(i-1,Display);

    }
}
